package gov.va.med.mhv.usermgmt.integration.service.delegate;

import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.ejb.EjbUtil;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.integration.registry.services.ejb.PatientIdentityServiceRemote;
import gov.va.med.mhv.integration.registry.services.ejb.PatientIdentityServiceRemoteHome;
import gov.va.med.mhv.integration.registry.transfer.Facility;
import gov.va.med.mhv.integration.registry.transfer.Patient;
import gov.va.med.mhv.integration.registry.transfer.PersonalInfo;
import gov.va.med.mhv.integration.registry.transfer.Status;
import gov.va.med.mhv.integration.registry.transfer.StatusType;
import gov.va.med.mhv.usermgmt.util.MessageKeys;

/**
 * Service delegate for the Patient service
 */
public class PatientIdentityServiceDelegateImpl 
    implements PatientIdentityServiceDelegate
{

	private static Log log = LogFactory.getLog(
        PatientIdentityServiceDelegateImpl.class);
    
	/**
	 * Create a new delegate.
	 */
	public PatientIdentityServiceDelegateImpl() {
		super();
		
	}

	/**
	 * Execute the GetPatientForUser service
	 *
	 * @return PatientServiceResponse
	 */
	public Status changeIcn(Patient patient, String icn) {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotEmpty("icn", icn);
		Status status = null;
		try {
			PatientIdentityServiceRemote remote = getRemoteService();
			status = (remote != null) ? remote.changeIcn(patient, icn)
				: (Status) serverUnavailable();
			
		} catch (RemoteException re) {
			String methodName = 
                "Status changeIcn(Patient patient, Status status)";
			status = handleRemoteException(methodName, re);
			
		}
		return status;
	}



    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.service.delegate.
     * PatientIdentityServiceDelegate#getPatientForICN(java.lang.String)
     */
    public Patient getPatientForICN(String icn) {
        Precondition.assertNotEmpty("icn", icn);
        Patient patient = null;
        try {
            PatientIdentityServiceRemote remote = getRemoteService();
            if (remote != null) {
                patient = remote.getPatientForICN(icn);
            } else {
                handleError(serverUnavailable());
            }
        } catch (RemoteException re) {
            String methodName = "Status getPatientForICN(String icn)";
            handleError(handleRemoteException(methodName, re));
            
        }
        return patient;
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.service.delegate.
     * PatientIdentityServiceDelegate#finalizeCorrelation(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.Status)
     */
    public Status finalizeCorrelation(Patient patient, Status status) {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotNull("status", status);
        try {
            PatientIdentityServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.finalizeCorrelation(patient, 
                status) : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status finalizeCorrelation(Patient patient, Status status)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.service.delegate.
     * PatientIdentityServiceDelegate#finalizeUncorrelation(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.Status)
     */
    public Status finalizeUncorrelation(Patient patient, Status status) {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotNull("status", status);
        try {
            PatientIdentityServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.finalizeUncorrelation(patient, 
                status) : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status finalizeUncorrelation(Patient patient, Status status)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.service.delegate.
     * PatientIdentityServiceDelegate#updateFacilities(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * java.util.ArrayList)
     */
    public Status updateFacilities(Patient patient, 
        ArrayList<Facility> newFacilities) 
    {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotNull("newFacilities", newFacilities);
        Status status = null;
        try {
            PatientIdentityServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.updateFacilities(patient, 
                newFacilities) : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status updateFacilities(Patient patient," 
                + " ArrayList<Facility> newFacilities)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.service.delegate.
     * PatientIdentityServiceDelegate#updatePersonalInfo(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.PersonalInfo)
     */
    public Status updatePersonalInfo(Patient patient, 
        PersonalInfo personalInfo) 
    {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotNull("personalInfo", personalInfo);
        Status status = null;
        try {
            PatientIdentityServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.updatePersonalInfo(patient, 
                personalInfo) : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status finalizeUncorrelation(Patient patient, Status status)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.service.delegate.
     * PatientIdentityServiceDelegate#removeCorrelation(
     * gov.va.med.mhv.integration.registry.transfer.Patient)
     */
    public Status removeCorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        Status status = null;
        try {
            PatientIdentityServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.removeCorrelation(patient) 
                : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status removeCorrelation(Patient patient)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.service.delegate.
     * PatientIdentityServiceDelegate#mergePatients(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.Patient, java.lang.String)
     */
    public Status mergePatients(Patient fromPatient, Patient toPatient, 
        String referenceId) 
    {
        Precondition.assertNotNull("fromPatient", fromPatient);
        Precondition.assertNotNull("toPatient", toPatient);
        Precondition.assertNotEmpty("referenceId", referenceId);
        Status status = null;
        try {
            PatientIdentityServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.mergePatients(fromPatient, 
                toPatient, referenceId) : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status mergePatients(Patient fromPatient, Patient toPatient," 
                + " String referenceId)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }


	/**
	 * Gets the remote stub for a session bean call
	 * @return The <tt>PatientServiceRemote</tt> to use to perform a remote call
	 */
	protected PatientIdentityServiceRemote getRemoteService() {
		PatientIdentityServiceRemote remote = null;
		Context ic = null;
		Object o = null;
		try {		
			ic = new InitialContext();
			o = PortableRemoteObject.narrow(ic.lookup(
                PatientIdentityServiceRemoteHome.JNDI_NAME),
				PatientIdentityServiceRemoteHome.class);
			PatientIdentityServiceRemoteHome home = (PatientIdentityServiceRemoteHome)o;
			remote = home.create();
		} catch (ClassCastException cce) {
			if (log.isErrorEnabled()) {				
				log.error("A class cast exception occurred looking up service \"PatientIdentityService\"'s remote stub." +
					" Expected \"PatientIdentityService\", but returned \"" + o.getClass() + "\"", cce);		
			}
			
		} catch (RemoteException re) {
			if (log.isErrorEnabled()) {
				log.error("A remote exception occurred looking up service \"PatientIdentityService\"'s remote stub", re);			
			}
			
		} catch (NamingException ne) {
			if (log.isErrorEnabled()) {
				log.error("A naming exception occurred looking up service \"PatientIdentityService\"'s remote stub", ne);			
			}
			
		} catch (CreateException ce) {
			if (log.isErrorEnabled()) {
				log.error("A creation exception occurred looking up service \"PatientIdentityService\"'s remote stub", ce);			
			}
			
		} finally {
			EjbUtil.closeContext(ic);
			
		}

		return remote;
	}

    private void handleError(Status status) {
        if ((status != null) && StatusType.Error.equals(status.getStatus())) {
            throw new RuntimeException(status.getStatusDescription());
        }
    }


	private Status handleRemoteException(String methodName, 
        RemoteException re) 
    {
		if (log.isErrorEnabled()) {
			log.error("Exception occurred during " + methodName, re);
			
		}
        Status status = new Status();
        status.setStatus(StatusType.Error);
        status.setStatusDescription(MessageKeys.UNKNOWN_EXCEPTION_OCCURRED);
		return status;
	}
	
	private Status serverUnavailable() {
		if (log.isErrorEnabled()) {
			log.error("\"PatientIdentityServiceRemote\" could not be found!");
			
		}
        Status status = new Status();
        status.setStatus(StatusType.Error);
        status.setStatusDescription("server.unavailable");
        return status;
	}
	
}